<?php

?>
<div class="col-md-9 ms-sm-auto col-lg-10 px-md-4 d-inline-block">
  <div class="container">
    <div class="row">
        <div class="col-md-6">
            <h5 class="">Contratos: </h5>
        </div>
        <div class="col-md-6 justify-content-end">
          <h5>&nbsp;&nbsp;<?php echo "  ".date('d/m/Y');?></h5>
        </div>
    </div>
    <hr>
    <!-- nuevo bloque -->
    <div class="row">
      <div class="col-md-12">
      <?php 
        include_once 'includes/database2.php';
        $productosPorPagina = 10;
        // Por defecto es la página 1; pero si está presente en la URL, tomamos esa
        $pagina = 1;
        if (isset($_GET["pagina"])) {
            $pagina = $_GET["pagina"];
        }
        # El límite es el número de productos por página
        $limit = $productosPorPagina;
        # El offset es saltar X productos que viene dado por multiplicar la página - 1 * los productos por página
        $offset = ($pagina - 1) * $productosPorPagina;
        # Necesitamos el conteo para saber cuántas páginas vamos a mostrar
       // $sentencia = $base_de_datos->query("SELECT count(*) conteo FROM factura1 INNER JOIN factura2 ON factura2.CODIGO = factura1.CODIGO
        //INNER JOIN clientes ON clientes.CODIGO = factura1.CLIENTE WHERE  factura1.CODIGO = factura2.CODIGO AND factura1.TIPO = 4");
        $sentencia = $base_de_datos->query("SELECT factura1.*, factura2.CODIGO, factura2.descripcio, factura2.UNIDADES, factura2.PRECIO, factura2.TOTAL_ITEM, factura2.FECHA, factura2.IdAlmacenSalida FROM factura1 INNER JOIN factura2 ON factura1.CODIGO = factura2.CODIGO");
        $conteo = $sentencia->fetchObject()->conteo;
        # Para obtener las páginas dividimos el conteo entre los productos por página, y redondeamos hacia arriba
        $paginas = ceil($conteo / $productosPorPagina);

        # Ahora obtenemos los productos usando ya el OFFSET y el LIMIT
       // $sentencia = $base_de_datos->prepare("SELECT * FROM factura1 LIMIT ? OFFSET ?");
        $sentencia = $base_de_datos->prepare("SELECT factura1.*, factura2.CODIGO, factura2.descripcio, factura2.UNIDADES, factura2.PRECIO, factura2.TOTAL_ITEM, factura2.FECHA, factura2.IdAlmacenSalida FROM factura1 INNER JOIN factura2 ON factura1.CODIGO = factura2.CODIGO LIMIT ? OFFSET ?");
        $sentencia->execute([$limit, $offset]);
        $productos = $sentencia->fetchAll(PDO::FETCH_OBJ);
        # Y más abajo los dibujamos...
        ?>
        
        <h5 class="card-tittle">Resultados (<?php //echo $num_registros; ?>)</h5>
      </div>
    </div>
    <hr>
    <div class="row">
      <div class="col-md-12">
        <table class="table table-striped colfuente" id="tabla">
          <thead>
              <tr>
                <th>Contratos</th>
                  <th >Nombre</th>
                  <th>C.I</th>
                  <th>Vendedor</th>
                  <th>Fecha</th>
                  <th>F/Vence</th>
                  <th>Total</th>
                  <th>Cuotas</th>
                  <th>M/Cuotas</th>
                  <th>F/Pago</th>
                  <th></th>
                  <th></th>
              </tr>
          </thead>
          <tbody>
          <?php foreach($productos as $resultado ){  ?>
              <tr>
                  <td><?php echo $resultado->CODIGO; ?></td>
                  <td><?php echo $resultado->NOMBRE; ?></td>
                  <td><?php echo $resultado->NOMB_CLI; ?></td>
                  <td><?php echo $resultado->FECHA; ?></td>
                  <td><?php echo $resultado->FECHA_VENCE; ?></td>
                  <td><?php echo $resultado->SALDO; ?></td>
                  <td><?php echo $resultado->canticuota; ?></td>
                  <td><?php echo $resultado->montocuota; ?></td>
                  <td><?php echo $resultado->formaPago; ?></td>
                  <td>
                      <a class="btn btn-sm btn-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Editar Cliente" href="?clase=cliente&accion=EditCliente&CODIGO=<?php echo $r->CODIGO; ?>"><i class="icon-edit bont"></i></a>
                  </td>
                  <td>
                      <a class="btn btn-sm btn-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Eliminar Registros" onclick="javascript:return confirm('¿Seguro de eliminar este registro?');" href="?clase=cliente&accion=BorrarClientes&CODIGO=<?php echo $r->CODIGO; ?>"><i class="icon-delete_sweep bont"></i></a>
                  </td>
              </tr>
          <?php } ?>
          </tbody>
        </table>
      <br><br>
      <nav>
            <div class="row">
                <div class="col-xs-12 col-sm-6">

                    <p>Mostrando <?php echo $productosPorPagina ?> de <?php echo $conteo ?> productos disponibles</p>
                </div>
                <div class="col-xs-12 col-sm-6">
                    <p>Página <?php echo $pagina ?> de <?php echo $paginas ?> </p>
                </div>
            </div>
            <ul class="pagination">
                <!-- Si la página actual es mayor a uno, mostramos el botón para ir una página atrás -->
                <?php if ($pagina > 1) { ?>
                    <li>
                        <a href="./listar.php?pagina=<?php echo $pagina - 1 ?>">
                            <span aria-hidden="true">&laquo;</span>
                        </a>
                    </li>
                <?php } ?>

                <!-- Mostramos enlaces para ir a todas las páginas. Es un simple ciclo for-->
                <?php for ($x = 1; $x <= $paginas; $x++) { ?>
                    <li class="<?php if ($x == $pagina) echo "active" ?>">
                        <a href="./listacontraprueba.php?pagina=<?php echo $x ?>">
                            <?php echo $x ?></a>
                    </li>
                <?php } ?>
                <!-- Si la página actual es menor al total de páginas, mostramos un botón para ir una página adelante -->
                <?php if ($pagina < $paginas) { ?>
                    <li>
                        <a href="./listacontraprueba.php?pagina=<?php echo $pagina + 1 ?>">
                            <span aria-hidden="true">&raquo;</span>
                        </a>
                    </li>
                <?php } ?>
            </ul>
        </nav>
      </div>
    </div><!--row tabla-->
  </div>  
</div><!--fin de main-->

    </div><!--row-->
  </div><!--container-->
  
  <!---->
  <script src="asses/js/bootstrap.bundle.min.js"></script>
  <script src="asses/js/dashboard.js"></script>

  <script  src="assets/js/datatable.js"></script>
</body>
</html>